<?php
/**
 * The template part for displaying single posts
 *
 * @package WordPress
 * @subpackage Automatic
 * @since Automatic 1.0
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header"> 
		<?php if ( has_post_thumbnail( get_the_ID() ) ) : ?>
			<div class="thumbnail-post">
				<a href="<?php the_permalink();?>" title="<?php the_title(); ?>"><?php the_post_thumbnail( 'full' ); ?></a>
			</div>
		<?php endif; ?>
		<?php the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
		<?php echo automatic_post_meta(); ?>
	</header><!-- .entry-header -->

	<div class="entry-content">
		<?php
			/* translators: %s: Name of current post */
			the_content();
			wp_link_pages( array(
				'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'automatic' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'automatic' ) . ' </span>%',
				'separator'   => '<span class="screen-reader-text">, </span>',
			) );
		?>
	</div><!-- .entry-content -->

	<footer class="entry-footer">
		<div class="post-bottom">
			<div class="row">
				<div class="col-xs-12 col-sm-6 col-md-8">
					<div class="tagcloud">
						<?php
						$posttags = get_the_tags();
						if ($posttags) {
							foreach($posttags as $tag) {
								echo '<a href="'.get_tag_link($tag->term_id).'">'.$tag->name.'</a>';
							}
						}
						?>
					</div>
				</div>
				<div class="col-xs-12 col-sm-6 col-md-4">
					<div class="social-share f_right">
						<span class="txt-share"><?php echo esc_html__('Share','automatic'); ?></span><?php automatic_socials_share(get_the_permalink(), get_the_title()); ?>
					</div>
				</div>
			</div>
		</div>
		<?php edit_post_link( esc_html__( 'Edit', 'automatic' ), '<footer class="entry-footer"><span class="edit-link">', '</span></footer><!-- .entry-footer -->' ); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-## -->
<?php 
if(automatic_post_comment()){?>
	<div class="post-author-box">
		<div class="img-author">
			<a href="<?php echo get_author_posts_url( get_the_author_meta('ID') ) ?>">
				<?php $author_id = get_the_author_meta('ID');
				echo get_avatar( $author_id, 100 );?>

			</a>
		</div>
		<div class="dsc-author">
			<a class="name-author" href="<?php
				echo get_author_posts_url( get_the_author_meta('ID') ) ?>"><?php echo get_the_author_meta('first_name'); ?>
			</a>
			<div class="info-author"><p><?php the_author_meta( 'description', $author_id ); ?></p></div>
		</div>
	</div>
	<?php if (get_comments_number() > 0){ ?>
		<div class="count-cmt">
			<span>
				<?php
					echo get_comments_number() .' ';
					if ( get_comments_number() > 1 ){
						echo esc_html__('Comment(s)','automatic');
					}else{
						echo esc_html__('Comment','automatic');
					}
				?>
			</span>
		</div>

	<?php }
	// If comments are open or we have at least one comment, load up the comment template.
		comments_template();
	// End of the loop.
}